<?php
  $form_id = get_the_ID();
  $form = new Give_Donate_Form( $form_id );
  $goal = apply_filters( 'give_goal_amount_target_output', $form->goal, $form_id, $form );
  $goal_option = give_get_meta( $form_id, '_give_goal_option', true );
  $progress = 0;
  $income = apply_filters( 'give_goal_amount_raised_output', $form->get_earnings(), $form_id, $form );
  $income = empty($income) ? 0 : $income;
   

   if($goal_option == 'disabled' || !$goal_option){
      $goal = 'unlimited';
      $progress = 100;
      $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
   }

  if($goal == 'unlimited'){
    $progress_label = esc_html__( 'unlimited' , 'halpes' );
    $progress = 100;
  }else{
    $progress = apply_filters( 'give_goal_amount_funded_percentage_output', round( ( $income / $goal ) * 100, 1 ), $form_id, $form );
    $progress_label = $progress . '%';
    $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
    $goal = give_currency_filter(give_format_amount( $goal, array( 'sanitize' => false ) ));
    if($progress > 100) $progress = 100;
  }

  if(!isset($excerpt_words)){
    $excerpt_words = oxpitan_get_option('give_excerpt_limit', 20);
  }
?>

<div class="give-block-2">
  <div class="give-block-content">
    <div class="give-title">
      <h2 class="title"><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h2>
    </div>

    <div class="give-content">
      <div class="funded">
        <div class="give__meta-top">
          <span class="raised"><?php echo esc_html($income) ?></span>
          <span class="percentage"><?php echo esc_html($progress_label); ?></span>
        </div>
        <div class="give__progress">
          <div class="give__progress-bar" data-progress-max="<?php echo esc_attr($progress)?>%">
          </div>
        </div>
        <div class="give__meta-bottom">
          <span class="goal"><?php echo esc_html__( 'of ', 'oxpitan' ); ?><?php echo esc_html($goal) ?><?php echo esc_html__( ' goal', 'oxpitan' ); ?></span>
          <span class="read-more"><a href="<?php the_permalink() ?>"><?php echo esc_html__( 'Read More', 'oxpitan' ) ?></a></span>
        </div>
      </div>
    </div>
  </div>  
</div>