<?php
/**
 * $Desc
 *
 * @version    1.0
 * @package    basetheme
 * @author     Gaviasthemes Team     
 * @copyright  Copyright (C) 2016 Gaviasthemess. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 * 
 */
    get_header(); 

    $sidebar_layout_config = oxpitan_get_option('search_page_layout_sidebar', 'right-sidebar'); 
    $sidebar = oxpitan_get_option('search_page_sidebar', 'default_sidebar');
    $main_content_config['class'] = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12';

    if( $sidebar_layout_config && $sidebar ){
        $main_content_config['class'] = 'col-xl-8 col-lg-8 col-md-12 col-sm-12 col-xs-12';
    }
    if( ( ( !$sidebar_layout_config) || ($sidebar_layout_config && !$sidebar) ) && is_active_sidebar('default_sidebar') ){
        $main_content_config['class'] = 'col-xl-8 col-lg-8 col-md-12 col-sm-12 col-xs-12';
    }
?>

<section id="wp-main-content" class="clearfix main-page title-layout-standard">
    <?php do_action( 'oxpitan_before_page_content' ); ?>
    <div class="container">
        <div class="row">
            <div class="content-page <?php echo esc_attr($main_content_config['class']); ?>"> 
                <div id="wp-content" class="wp-content">
                    <?php  if ( have_posts() ) : ?>
                        <div class="post-area results-search clearfix blog-grid-style post-items">
                            <div class="lg-block-grid-2 md-block-grid-2 sm-block-grid-2 xs-block-grid-1 post-masonry-style">
                                <?php  while ( have_posts() ) : the_post(); ?>
                                    <div class="item-columns item-masory margin-bottom-30">
                                        <div class="post post-block">

                                            <?php if(has_post_thumbnail()){ ?>
                                                <div class="post-thumbnail">
                                                    <?php the_post_thumbnail(); ?>
                                                </div>
                                            <?php } ?>    

                                            <div class="entry-content">
                                                <div class="content-inner">
                                                    <div class="content-top entry-meta">
                                                       <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ){ ?>
                                                          <span class="cat-links"><?php echo get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'oxpitan' ) ); ?></span>
                                                          <span class="line"></span>
                                                       <?php } ?>
                                                       <?php oxpitan_posted_on(); ?>
                                                    </div> 
                                                    <h2 class="entry-title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h2>
                                                    <?php echo oxpitan_limit_words( 16, get_the_excerpt(), '' );?>
                                                </div>
                                                <?php the_tags( '<footer class="entry-meta"><span class="tag-links">', '', '</span></footer>' ); ?>
                                              <div class="read-more hidden"><a class="btn-theme" href="<?php echo esc_url( get_permalink() ) ?>"><?php echo esc_html__( 'Read more ', 'oxpitan' ) ?></a></div>
                                              
                                            </div><!-- .entry-content -->   
                                        </div>
                                    </div>    
                                <?php endwhile; ?> 
                            </div>       
                        </div>                    
                    <?php else: ?>
                        <div class="alert alert-danger"><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'oxpitan' ); ?></div>
                    <?php endif ?>
                    <div class="pagination">
                        <?php echo oxpitan_pagination(); ?>
                     </div>
                </div>
            </div>

            <?php if( ( ( !$sidebar_layout_config) || ($sidebar_layout_config && !$sidebar) ) && is_active_sidebar('default_sidebar') ): ?>
                <div class="sidebar wp-sidebar sidebar-right col-xl-4 col-lg-4 col-md-12 col-sm-12 col-xs-12 order-xl-2 order-lg-2 order-md-2 order-sm-2 order-xs-2">
                    <?php do_action( 'oxpitan_before_sidebar' ); ?>
                    <div class="sidebar-inner">
                       <?php get_sidebar(); ?>
                    </div>
                    <?php do_action( 'oxpitan_after_sidebar' ); ?>
                </div>
            <?php endif ?>

            <!-- Left Sidebar -->
            <?php if($sidebar_layout_config && $sidebar && $sidebar_layout_config == 'left-sidebar'): ?>
                <div class="sidebar wp-sidebar sidebar-left col-xl-4 col-lg-4 col-md-12 col-sm-12 col-xs-12 order-xl-1 order-lg-1 order-md-4 order-sm-4 order-xs-4">
                    <?php do_action( 'oxpitan_before_sidebar' ); ?>
                    <div class="sidebar-inner">
                       <?php dynamic_sidebar( $sidebar ); ?>
                    </div>
                    <?php do_action( 'oxpitan_after_sidebar' ); ?>
                </div>
            <?php endif ?>

            <!-- Right Sidebar -->
            <?php if($sidebar_layout_config && $sidebar && $sidebar_layout_config == 'right-sidebar'): ?>
                <div class="sidebar wp-sidebar sidebar-right col-xl-4 col-lg-4 col-md-12 col-sm-12 col-xs-12 order-xl-5 order-lg-5 order-md-5 order-sm-5 order-xs-5">
                    <?php do_action( 'oxpitan_before_sidebar' ); ?>
                    <div class="sidebar-inner">
                       <?php dynamic_sidebar( $sidebar ); ?>
                    </div>
                    <?php do_action( 'oxpitan_after_sidebar' ); ?>
                </div>
            <?php endif ?>

            

        </div>
    </div>
    <?php do_action( 'oxpitan_after_page_content' ); ?>
</section>
<?php get_footer(); ?>
