<?php
if(!function_exists('oxpitan_id')){
  function oxpitan_id(){
    if(oxpitan_woocommerce_activated() && is_shop()){
      $pid = wc_get_page_id('shop');
    }elseif(is_page() || is_singular()){
      $pid = get_the_ID();
    }else{
      $pid = '';
    }
    return $pid;
  }
}

if(!function_exists('oxpitan_get_footer')){
  function oxpitan_get_footer(){
    $footers['__default_option_theme'] = esc_html__('Default Option Theme', 'oxpitan');
    if(class_exists('Gavias_Themer_Footer')){
      $footers = $footers + Gavias_Themer_Footer::getInstance()->get_footers();
    }  
    $footers['__disable_footer'] = esc_html__('Disable Footer', 'oxpitan');
    return $footers;
  }
}  

if(!function_exists('oxpitan_get_headers')){
  function oxpitan_get_headers(){
    $path = get_template_directory().'/header-*.php';
    $files = glob( $path  );
    $headers = array('__default_option_theme' => esc_html__('Default Option Theme', 'oxpitan') );
    $headers['v__'] = esc_html__('Default', 'oxpitan');
    if( count($files)>0 ){
      foreach ($files as $key => $file) {
        $name = str_replace( "header-", '', str_replace( '.php', '', basename($file) ) );
        $headers[$name] = esc_html__( 'Header', 'oxpitan' ) . ' ' .str_replace( '-',' ', ucfirst( $name ) );
        }
    }
    return $headers;
  }
}

if(!function_exists('oxpitan_general_breadcrumbs')){
  function oxpitan_general_breadcrumbs() {

    $delimiter = ' / ';
    $home = esc_html__('Home', 'oxpitan');
    $before = '<li class="active">&nbsp;' . $delimiter;
    $after = '</li>';
    $breadcrumb = '';
    $page_title = '';
    if (!is_home() && !is_front_page() || is_paged()) {

      $breadcrumb .= '<ol class="breadcrumb">';

      global $post;
      $homeLink = home_url();
      $breadcrumb .= '<li><a href="' . $homeLink . '">' . $home . '</a></li> ';

      if (is_category()) {
        
        global $wp_query;
        $cat_obj = $wp_query->get_queried_object();
        $thisCat = $cat_obj->term_id;
        $thisCat = get_category($thisCat);
        $parentCat = get_category($thisCat->parent);
        if ($thisCat->parent != 0) $breadcrumb .= (get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
        $breadcrumb .= ($before) . single_cat_title('', false) . $after;
        $page_title = single_cat_title('', false );
     
      } elseif (is_day()) {
        
        $breadcrumb .= '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
        $breadcrumb .= '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
        $breadcrumb .= ($before) . get_the_time('d') . $after;
        $page_title = get_the_time('d');
     
      } elseif (is_month()) {
        
        $breadcrumb .= '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
        $breadcrumb .= ($before) . get_the_time('F') . $after;
        $page_title = get_the_time('F');
     
      } elseif (is_year()) {
       
        $breadcrumb .= ($before) . get_the_time('Y') . $after;
        $page_title = get_the_time('Y');
      
      }elseif ( is_search() || get_query_var('s') ) {

        $breadcrumb .= ($before) . 'Search results for "' . get_search_query() . '"' . $after;
        $page_title = get_search_query();

      } elseif (is_single() && !is_attachment()) {
        if ( get_post_type() != 'post' ) {
          $breadcrumb .= ($before) . get_the_title() . $after;
          $page_title = get_the_title();
        } else {
          $cat = get_the_category(); $cat = $cat[0];
          $breadcrumb .= '<li>&nbsp;' . $delimiter . ' ' . get_category_parents($cat, TRUE, '') . '</li>';
       
          $breadcrumb .= ($before) . get_the_title() . $after;
          $page_title = get_the_title();
        }

      } elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
        
        $post_type = get_post_type_object(get_post_type());
        if( $post_type ){
          $breadcrumb .= ($before) . $post_type->labels->singular_name . $after;
          $page_title = $post_type->labels->singular_name;
        }

      } elseif (is_attachment()) {

        $parent = get_post($post->post_parent);
        $cat = get_the_category($parent->ID); 
        if(isset($cat[0]) && $cat[0]){
          $cat = $cat[0];
          $breadcrumb .= get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
        }
        $breadcrumb .= '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
        $breadcrumb .= ($before) . get_the_title() . $after;
        $page_title = get_the_title();

      } elseif ( is_page() && !$post->post_parent ) {
        
        $breadcrumb .= ($before) . get_the_title() . $after;
        $page_title = get_the_title();

      } elseif ( is_page() && $post->post_parent ) {

        $parent_id  = $post->post_parent;
        $breadcrumbs = array();
        while ($parent_id) {
          $page = get_page($parent_id);
          $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
          $parent_id  = $page->post_parent;
        }
        $breadcrumbs = array_reverse($breadcrumbs);
        foreach ($breadcrumbs as $crumb) $breadcrumb .= '<li>&nbsp;'. $delimiter . ($crumb)  . '</li>';
        $breadcrumb .= ($before) . get_the_title() . $after;
        $page_title = get_the_title();

      }  elseif ( is_tag() ) {

        $breadcrumb .= ($before) . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
        $page_title = single_tag_title('', false);

      } elseif ( is_author() ) {

        global $author;
        $userdata = get_userdata($author);
        if($userdata){
          $breadcrumb .= ($before) . 'Articles posted by ' . $userdata->display_name . $after;
          $page_title = $userdata->display_name;
        } 

      } elseif ( is_404() ) {

        $breadcrumb .= ($before) . 'Error 404' . $after;
        $page_title = 'Error 404';

      }

      if ( get_query_var('paged') ) {

        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) $breadcrumb .= ' (';
        $breadcrumb .= ': ' . esc_html__('Page','oxpitan') . ' ' . get_query_var('paged');
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) $breadcrumb .= ')';

      }

      $breadcrumb .= '</ol>';
      echo trim($breadcrumb);
    }
  }
}  

if ( ! function_exists( 'oxpitan_comment_nav' ) ) :
/**
 * Display navigation to next/previous comments when applicable.
 *
 */
function oxpitan_comment_nav() {
  // Are there comments to navigate through?
  if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
  ?>
  <nav class="navigation comment-navigation" role="navigation">
    <h2 class="screen-reader-text"><?php esc_html__( 'Comment navigation', 'oxpitan' ); ?></h2>
    <div class="nav-links">
      <?php
        if ( $prev_link = get_previous_comments_link( esc_html__( 'Older Comments', 'oxpitan' ) ) ) :
          printf( '<div class="nav-previous">%s</div>', $prev_link );
        endif;

        if ( $next_link = get_next_comments_link( esc_html__( 'Newer Comments', 'oxpitan' ) ) ) :
          printf( '<div class="nav-next">%s</div>', $next_link );
        endif;
      ?>
    </div><!-- .nav-links -->
  </nav><!-- .comment-navigation -->
  <?php
  endif;
}
endif;

 function oxpitan_category_count( $links ) {
  $links = str_replace( '(', '<span class="count">(', $links );
  $links = str_replace( ')', ')</span>', $links );
  return $links;
 }
 add_filter( 'wp_list_categories', 'oxpitan_category_count' );

 function oxpitan_archive_count($links) {
  $links = str_replace( '&nbsp;(', '<span class="count">(', $links );
  $links = str_replace( ')', ')</span>', $links );
  return $links;
 }
 add_filter( 'get_archives_link', 'oxpitan_archive_count' );

function oxpitan_limit_words($word_limit, $string, $string_second = ''){
  if(empty($string)){
    $string = strip_tags($string_second);
  }
  $words = explode(' ', $string, ($word_limit + 1));
  if(count($words) > $word_limit)
  array_pop($words);
  return implode(' ', $words);
}

if(!function_exists('oxpitan_get_options')){
  function oxpitan_get_options(){
    global $oxpitan_theme_options;
    return $oxpitan_theme_options;
  }
}

if(!function_exists('oxpitan_get_option')){
  function oxpitan_get_option($key, $default = ''){
    global $oxpitan_theme_options;
    if(isset($oxpitan_theme_options[$key]) && $oxpitan_theme_options[$key]){
      return $oxpitan_theme_options[$key];
    }else{
      return $default;
    }
  }
}

if(!function_exists('oxpitan_random_id')){
  function oxpitan_random_id($length=4){
    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
    $string = '';
    for ($i = 0; $i < $length; $i++) {
      $string .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $string;
  }
}  

if(!function_exists('oxpitan_woocommerce_activated')){
  /* Check if WooCommerce is activated */
  function oxpitan_woocommerce_activated() {
    if ( class_exists('WooCommerce') ) { 
      return true; 
    }
    return false;
  }
}

if(!function_exists('oxpitan_convert_hextorgb')){
  function oxpitan_convert_hextorgb($hex, $alpha = false) {
    $hex = str_replace('#', '', $hex);
    if ( strlen($hex) == 6 ) {
      $rgb['r'] = hexdec(substr($hex, 0, 2));
      $rgb['g'] = hexdec(substr($hex, 2, 2));
      $rgb['b'] = hexdec(substr($hex, 4, 2));
    }else if ( strlen($hex) == 3 ) {
      $rgb['r'] = hexdec(str_repeat(substr($hex, 0, 1), 2));
      $rgb['g'] = hexdec(str_repeat(substr($hex, 1, 1), 2));
      $rgb['b'] = hexdec(str_repeat(substr($hex, 2, 1), 2));
    }else {
      $rgb['r'] = '0';
      $rgb['g'] = '0';
      $rgb['b'] = '0';
     }
     if ( $alpha ) {
      $rgb['a'] = $alpha;
    }
    return $rgb;
  }
}

if(!function_exists('oxpitan_set_carousel_attrs')){
  function oxpitan_set_carousel_attrs($attrs = array()){
    $ouput = '';
    foreach ($attrs as $key => $value) {
      $ouput .= 'data-' . esc_attr( $key ) . '="' . esc_attr($value) . '" ';
    }
    return $ouput;
  }
}


function oxpitan_responsive_settings(){
  return array(
    array(
      'type'           => 'dropdown',
      'heading'        => esc_html__( 'Responsive Setting | Items for large Screen', 'oxpitan' ),
      "param_name"     => 'items_lg',
      'value'          => array(1=>1, 2=>2, 3=>3, 4=>4, 5=>5, 6=>6),
      'std'            => 4
    ),
    array(
      'type'           => 'dropdown',
      'heading'        => esc_html__( 'Responsive Setting | Items for Medium Screen', 'oxpitan' ),
      "param_name"     => 'items_md',
      'value'          => array(1=>1, 2=>2, 3=>3, 4=>4, 5=>5, 6=>6),
      'std'            => 3
    ),
    array(
      'type'           => 'dropdown',
      'heading'        => esc_html__( 'Responsive Setting | Items for Small Screen', 'oxpitan' ),
      "param_name"     => 'items_sm',
      'value'          => array(1=>1, 2=>2, 3=>3, 4=>4, 5=>5, 6=>6),
      'std'            => 2
    ),
    array(
      'type'           => 'dropdown',
      'heading'        => esc_html__( 'Responsive Setting | Items for Extra Small Screen', 'oxpitan' ),
      "param_name"     => 'items_xs',
      'value'          => array(1=>1, 2=>2, 3=>3, 4=>4, 5=>5, 6=>6),
      'std'            => 2
    )
  );
}

function oxpitan_carousel_settings(){
  return array(
    array(
      "type"          => "dropdown",
      "heading"       => esc_html__("Carousel Settings | Loop", 'oxpitan'),
      "param_name"    => "ca_loop",
      "value"         => array(
        esc_html__("Enable", 'oxpitan' ) => '1',
        esc_html__("Disable", 'oxpitan' ) => '0'
      ),
    ),
    array(
      "type"          => "textfield",
      "heading"       => esc_html__("Carousel Settings | Speed", 'oxpitan'),
      "param_name"    => "ca_speed",
      "value"         => '1000'
    ),
    array(
      "type"          => "dropdown",
      "heading"       => esc_html__("Carousel Settings | Auto Play", 'oxpitan'),
      "param_name"    => "ca_auto_play",
      "value"         => array(
        esc_html__("Enable", 'oxpitan' ) => '1',
        esc_html__("Disable", 'oxpitan' ) => '0'
      )
    ),
    array(
      "type"        => "textfield",
      "heading"     => esc_html__("Carousel Settings | Auto Play Timeout", 'oxpitan'),
      "param_name"  => "ca_auto_play_timeout",
      "value"       => '3000'
    ),
    array(
      "type"        => "textfield",
      "heading"     => esc_html__("Carousel Settings | Auto Play Speed", 'oxpitan'),
      "param_name"  => "ca_auto_play_speed",
      "value"       => '1000'
    ),
    array(
      "type"        => "dropdown",
      "heading"     => esc_html__("Carousel Settings | Play Hover", 'oxpitan'),
      "param_name"  => "ca_play_hover",
      "value"       => array(
        esc_html__("Enable", 'oxpitan' )   => '1',
        esc_html__("Disable", 'oxpitan' )  => '0'
      )
    ),
    array(
      "type"        => "dropdown",
      "heading"     => esc_html__("Carousel Settings | Navigation", 'oxpitan'),
      "param_name"  => "ca_navigation",
      "value"       => array(
        esc_html__("Enable", 'oxpitan' )   => '1',
        esc_html__("Disable", 'oxpitan' )  => '0'
      )
    ),
    array(
      "type"        => "dropdown",
      "heading"     => esc_html__("Carousel Settings | Rewind Nav", 'oxpitan'),
      "param_name"  => "ca_rewind_nav",
      "value"       => array(
        esc_html__("Enable", 'oxpitan' )   => '1',
        esc_html__("Disable", 'oxpitan' )  => '0'
      )
    ),
    array(
      "type"        => "dropdown",
      "heading"     => esc_html__("Carousel Settings | Pagination", 'oxpitan'),
      "param_name"  => "ca_pagination",
      "value"       => array(
        esc_html__("Enable", 'oxpitan' )   => '1',
        esc_html__("Disable", 'oxpitan' )  => '0'
      )
    ),
    array(
      "type"        => "dropdown",
      "heading"     => esc_html__("Carousel Settings | Mouse Drag", 'oxpitan'),
      "param_name"  => "ca_mouse_drag",
      "value"       => array(
        esc_html__("Enable", 'oxpitan' )   => '1',
        esc_html__("Disable", 'oxpitan' )  => '0'
      )
    ),
    array(
      "type"        => "dropdown",
      "heading"     => esc_html__("Carousel Settings | Touch Drag", 'oxpitan'),
      "param_name"  => "ca_touch_drag",
      "value"       => array(
        esc_html__("Enable", 'oxpitan' )   => '1',
        esc_html__("Disable", 'oxpitan' )  => '0'
      )
    )
  );
}

function oxpitan_scheme_colors(){
  $results = array();
  $results[''] = esc_html__('--None--', 'oxpitan');
  $colors = oxpitan_get_option('scheme_color');
  if(!$colors) $colors = array('Turquoise[#00BDC0]', 'Tomato[#F86048]', 'GoldenRod[#FFA940]', 'Violet[#9238A4]');
  foreach ($colors as $color_tmp) {
    $title = $color = '';
    $tmp = explode('[', $color_tmp);
    $title = isset($tmp[0]) ? $tmp[0] : ''; 
    $color = isset($tmp[1]) ? str_replace(']', '', $tmp[1]) : ''; 
    if(!empty($title) && !empty($color)){
      $results[str_replace('-', ' ', strtolower($title))] = $title;
    }
  }
  return $results;
}
