<?php
if(!function_exists('oxpitan_give_breadcrumb')){
   function oxpitan_give_breadcrumb(){
      $result = oxpitan_style_breadcrumb();
      extract($result);
      if(isset($no_breadcrumbs) && $no_breadcrumbs == true){
         echo '<div class="disable-breadcrumb clearfix"></div>';
         return false;
      }
      ?>
      
         <div class="custom-breadcrumb <?php echo implode(' ', $classes); ?>" <?php echo(count($styles) > 0 ? 'style="' . implode(';', $styles) . '"' : ''); ?>>
          <?php if($styles_overlay){ ?>
             <div class="breadcrumb-overlay" style="<?php echo esc_attr($styles_overlay); ?>"></div>
          <?php } ?>
          <div class="breadcrumb-main">
            <div class="container">
              <div class="breadcrumb-container-inner">
                <?php if($title && ( $show_page_title || empty($show_page_title) ) ){ 
                  echo '<h2 class="heading-title">' . esc_html( $title ) . '</h2>';
                } ?>
                <?php oxpitan_general_breadcrumbs(); ?>
              </div>  
            </div>   
          </div>  
       </div>
      <?php
   }
   add_action( 'oxpitan_give_before_main_content', 'oxpitan_give_breadcrumb', 20 );
}

function oxpitan_give_change_posts_per_page( $query ) {
   if ( is_admin() || ! $query->is_main_query() ) {
      return;
   }
   $posts_per_page = oxpitan_get_option('give_posts_per_page', 6);
   if ( is_post_type_archive( 'give_forms' ) ) {
      $query->set( 'posts_per_page', $posts_per_page );
   }
}
add_filter( 'pre_get_posts', 'oxpitan_give_change_posts_per_page' );

function oxpitan_give_get_donation_form_submit_button( $form_id, $args = array() ) {
  global $post;
  if( isset( $post->ID) && $post->ID ){
    $form_id = $post->ID;
  }
  $display_label_field = give_get_meta( $form_id, '_give_checkout_label', true, '', 'form' );
  $display_label_field = apply_filters( 'give_donation_form_submit_button_text', $display_label_field, $form_id, $args );
  $display_label       = ( ! empty( $display_label_field ) ? $display_label_field : esc_html__( 'Donate Now', 'give' ) );
  ob_start();
  ?>
  <div class="give-submit-button-wrap give-clearfix">
    <button type="submit" class="give-submit give-btn" id="give-purchase-button" name="give-purchase" value="<?php echo esc_attr($display_label); ?>" data-before-validation-label="<?php echo esc_attr($display_label); ?>">
         <?php echo esc_html($display_label); ?>
    </button>
    <span class="give-loading-animation"></span>
  </div>
  <?php
  return ob_get_clean();
}
add_filter( '__give_donation_form_submit_button', 'oxpitan_give_get_donation_form_submit_button');

function oxpitan_give_display_checkout_button( $output ) {
  $output = '<div class="clearfix d-block">'.$output.'</div>';
  echo wp_kses( $output, true );
}

add_filter( '__give_display_checkout_button', 'oxpitan_give_display_checkout_button', 1);

function oxpitan_give_setup_taxonomies(){
  if(function_exists('give_update_option') ){
    if(give_get_option( 'form_sidebar', '') || give_get_option( 'form_sidebar') == 'enabled'){
      give_update_option('form_sidebar', 'disabled');
    }
  }
}
add_action( 'init', 'oxpitan_give_setup_taxonomies', 1 );
