<?php
/**
 * $Desc
 *
 * @version    1.0
 * @package    basetheme
 * @author     Gaviasthemes Team     
 * @copyright  Copyright (C) 2019 Gaviasthemess. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 * 
 */

define( 'OXPITAN_THEMER_DIR', get_template_directory() );
define( 'OXPITAN_THEME_URL', get_template_directory_uri() );

/*
 * Include list of files from Gavias Framework.
 */
require_once(OXPITAN_THEMER_DIR . '/includes/theme-functions.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/template.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/theme-hook.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/theme-layout.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/metaboxes.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/customize/custom-color.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/customize/custom-typo.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/menu/megamenu.php'); 
require_once(OXPITAN_THEMER_DIR . '/includes/sample/init.php');

//Load Woocommerce
if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
  add_theme_support( "woocommerce" );
  require_once(OXPITAN_THEMER_DIR . '/includes/woocommerce/functions.php'); 
  require_once(OXPITAN_THEMER_DIR . '/includes/woocommerce/hooks.php'); 
}
//Load Give
if( in_array( 'give/give.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
  require_once(OXPITAN_THEMER_DIR . '/includes/give/hooks.php'); 
}
// Load Redux - Theme options framework
if( class_exists( 'Redux' ) ){
  require( OXPITAN_THEMER_DIR . '/includes/options/options-config.php' ); 
} 
// TGM plugin activation
if ( is_admin() ) {
  require_once( OXPITAN_THEMER_DIR . '/includes/tgmpa/class-tgm-plugin-activation.php' );
  require( OXPITAN_THEMER_DIR . '/includes/tgmpa/config.php' );
}
load_theme_textdomain( 'oxpitan', get_template_directory() . '/languages' );

//-------- Register sidebar default in theme -----------
//------------------------------------------------------
function oxpitan_widgets_init() {
    
    register_sidebar( array(
        'name' => esc_html__( 'Default Sidebar', 'oxpitan' ),
        'id' => 'default_sidebar',
        'description' => esc_html__( 'Appears in the Default Sidebar section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Plugin| WooCommerce Sidebar', 'oxpitan' ),
        'id' => 'woocommerce_sidebar',
        'description' => esc_html__( 'Appears in the Plugin WooCommerce section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Plugin| WooCommerce Single', 'oxpitan' ),
        'id' => 'woocommerce_single_summary',
        'description' => esc_html__( 'Appears in the WooCommerce Single Page like social, description text ...', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Plugin| Give Sidebar', 'oxpitan' ),
        'id' => 'give_sidebar',
        'description' => esc_html__( 'Appears in the Give Form Page like social, description text ...', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Portfolio Sidebar', 'oxpitan' ),
        'id' => 'portfolio_sidebar',
        'description' => esc_html__( 'Appears in the Portfolio Page section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'After Offcanvas Mobile', 'oxpitan' ),
        'id' => 'offcanvas_sidebar_mobile',
        'description' => esc_html__( 'Appears in the Offcanvas section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Offcanvas Sidebar', 'oxpitan' ),
        'id' => 'offcanvas_sidebar',
        'description' => esc_html__( 'Appears in the Offcanvas section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Blog Sidebar', 'oxpitan' ),
        'id' => 'blog_sidebar',
        'description' => esc_html__( 'Appears in the Blog sidebar section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Page Sidebar', 'oxpitan' ),
        'id' => 'other_sidebar',
        'description' => esc_html__( 'Appears in the Page Sidebar section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer first', 'oxpitan' ),
        'id' => 'footer-sidebar-1',
        'description' => esc_html__( 'Appears in the Footer first section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer second', 'oxpitan' ),
        'id' => 'footer-sidebar-2',
        'description' => esc_html__( 'Appears in the Footer second section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer third', 'oxpitan' ),
        'id' => 'footer-sidebar-3',
        'description' => esc_html__( 'Appears in the Footer third section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
    register_sidebar( array(
        'name' => esc_html__( 'Footer four', 'oxpitan' ),
        'id' => 'footer-sidebar-4',
        'description' => esc_html__( 'Appears in the Footer four section of the site.', 'oxpitan' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title"><span>',
        'after_title' => '</span></h3>',
    ) );
}
add_action( 'widgets_init', 'oxpitan_widgets_init' );


if ( ! function_exists( 'oxpitan_fonts_url' ) ) :
/**
 *
 * @return string Google fonts URL for the theme.
 */
function oxpitan_fonts_url() {
  $fonts_url = '';
  $fonts     = array();
  $subsets   = '';
  $protocol = is_ssl() ? 'https' : 'http';
  /*
   * Translators: If there are characters in your language that are not supported
   * by Noto Sans, translate this to 'off'. Do not translate into your own language.
   */
  if ( 'off' !== _x( 'on', 'Playfair Display font: on or off', 'oxpitan' ) ) {
    $fonts[] = 'Playfair+Display:400,700,900';
  }

   if ( 'off' !== _x( 'on', 'Poppins font: on or off', 'oxpitan' ) ) {
    $fonts[] = 'Poppins:400,500,600,700';
  }
  
  /*
   * Translators: To add an additional character subset specific to your language,
   * translate this to 'greek', 'cyrillic', 'devanagari' or 'vietnamese'. Do not translate into your own language.
   */
  $subset = _x( 'no-subset', 'Add new subset (greek, cyrillic, devanagari, vietnamese)', 'oxpitan' );

  if ( 'cyrillic' == $subset ) {
    $subsets .= ',cyrillic,cyrillic-ext';
  } elseif ( 'greek' == $subset ) {
    $subsets .= ',greek,greek-ext';
  } elseif ( 'devanagari' == $subset ) {
    $subsets .= ',devanagari';
  } elseif ( 'vietnamese' == $subset ) {
    $subsets .= ',vietnamese';
  }

  if ( $fonts ) {
    $fonts_url = add_query_arg( array(
      'family' => ( implode( '%7C', $fonts ) ),
      'subset' => ( $subsets ),
    ),  $protocol.'://fonts.googleapis.com/css' );
  }

  return $fonts_url;
}
endif;

function oxpitan_custom_styles() {
  $custom_css = get_option( 'oxpitan_theme_custom_styles' );
  if($custom_css){
    wp_enqueue_style(
      'oxpitan-custom-style',
      get_template_directory_uri() . '/css/custom_script.css'
    );
    wp_add_inline_style( 'oxpitan-custom-style', $custom_css );
  }
}
add_action( 'wp_enqueue_scripts', 'oxpitan_custom_styles', 9999 );

function oxpitan_custom_styles_scheme_color() {
  $colors = oxpitan_get_option('scheme_color');
  if(!$colors) $colors = array('Turquoise[#00BDC0]', 'Tomato[#F86048]', 'GoldenRod[#FFA940]', 'Violet[#9238A4]', 'Brown[#684035]', 'Pink[#D91897]', 'Green[#50AF4D]', 'Purple[#9854B3]');
  $css = '';
  foreach ($colors as $color_tmp) { //foreach
    $title = $color = '';
    $tmp = explode('[', $color_tmp);
    $title = isset($tmp[0]) ? $tmp[0] : ''; 
    $color = isset($tmp[1]) ? str_replace(']', '', $tmp[1]) : ''; 
    if(!empty($title) && !empty($color)){ //if
      $selector = '.' . str_replace('-', ' ', strtolower($title));
      $css .= "{$selector}.give-block .campaign-action .btn-give-theme{background:{$color};}";
      $css .= "{$selector}.give-block .campaign-action .btn-give-theme::before{background:{$color};}";
      $css .= "{$selector}.give-block .give__progress-bar{background-color:{$color};}";
      $css .= "{$selector}.give-block .give__progress .give__progress-bar .percentage{background:{$color};}";
      $css .= "{$selector}.give-block .give__progress .give__progress-bar .percentage::after{border-top-color:{$color};}";
      $css .= "{$selector}.give-block .form-content .form-content-inner .campaign-content-inner .title a:hover{color:{$color};}";
      $css .= ".team-v2 {$selector}.bg-overlay{background:{$color};}";
      $css .= "{$selector}.event-block .event-image .event-date, {$selector}.event-block .event-image .event-date:before{background:{$color};}";
      $css .= "{$selector}.event-block .event-content .event-meta{color:{$color};}";
      $css .= "{$selector}.event-block .event-content .event-info .title a:hover{color:{$color};}";
      $css .= "{$selector}.gallery-post .background-overlay{background:{$color};}";
    }//endif
  } //endforeach
  if($css){
    wp_enqueue_style(
      'oxpitan-scheme-color',
      get_template_directory_uri() . '/css/custom_script.css'
    );
    wp_add_inline_style( 'oxpitan-scheme-color', $css );
  }
}
add_action( 'wp_enqueue_scripts', 'oxpitan_custom_styles_scheme_color', 9999 );

function oxpitan_init_scripts(){
  global $post;
  $protocol = is_ssl() ? 'https' : 'http';
  if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ){
    wp_enqueue_script( 'comment-reply' );
  }

  $theme = wp_get_theme();
  $theme_version = $theme['Version'];

  wp_enqueue_style( 'oxpitan-fonts', oxpitan_fonts_url(), array(), null );
  wp_enqueue_script('bootstrap', get_template_directory_uri().'/js/bootstrap.js', array('jquery') );
  wp_enqueue_script('scrollbar', get_template_directory_uri() . '/js/perfect-scrollbar.jquery.min.js');
  wp_enqueue_script('magnific', get_template_directory_uri() .'/js/magnific/jquery.magnific-popup.min.js');
  wp_enqueue_script('cookie', get_template_directory_uri() . '/js/jquery.cookie.js', array('jquery'));
  wp_enqueue_script('lightgallery', get_template_directory_uri() . '/js/lightgallery/js/lightgallery.min.js' );
  wp_enqueue_script('sticky', get_template_directory_uri() . '/js/sticky.js', array('elementor-waypoints'));
  wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl-carousel/owl.carousel.min.js');
  wp_enqueue_script('oxpitan-main', get_template_directory_uri() . '/js/main.js', array('imagesloaded', 'jquery-masonry'));
  wp_enqueue_script('oxpitan-woocommerce', get_template_directory_uri() . '/js/woocommerce.js');

  if(oxpitan_woocommerce_activated() ){
    wp_dequeue_script('wc-add-to-cart');
    wp_register_script( 'wc-add-to-cart', OXPITAN_THEME_URL . '/js/add-to-cart.js' , array( 'jquery' ) );
    wp_enqueue_script('wc-add-to-cart');
  }

  wp_enqueue_style('lightgallery', get_template_directory_uri() . '/js/lightgallery/css/lightgallery.min.css');
  wp_enqueue_style('lightgallery', get_template_directory_uri() . '/js/lightgallery/css/lg-transitions.min.css');
  wp_enqueue_style('owl-carousel', get_template_directory_uri() .'/js/owl-carousel/assets/owl.carousel.css');
  wp_enqueue_style('magnific', get_template_directory_uri() .'/js/magnific/magnific-popup.css');
  wp_enqueue_style('fontawesome', get_template_directory_uri() . '/css/fontawesome/css/font-awesome.css');
  wp_enqueue_style('oxpitan-icons', get_template_directory_uri() . '/css/icon-custom.css');
  wp_enqueue_style('oxpitan-style', get_template_directory_uri() . '/style.css');

  $skin = oxpitan_get_option('skin_color', '');
  if(isset($_GET['gskin']) && $_GET['gskin']){
      $skin = $_GET['gskin'];
  }
  if(!empty($skin)){
      $skin = 'skins/' . $skin . '/'; 
  }
  wp_enqueue_style('bootstrap', get_template_directory_uri(). '/css/' . $skin . 'bootstrap.css', array(), $theme_version, 'all'); 
  wp_enqueue_style('oxpitan-woocoomerce', get_template_directory_uri(). '/css/' . $skin . 'woocommerce.css', array(), $theme_version, 'all'); 
  wp_enqueue_style('oxpitan-template', get_template_directory_uri().'/css/' . $skin . 'template.css', array(), $theme_version, 'all');
}
add_action('wp_enqueue_scripts', 'oxpitan_init_scripts', 99);

 //update_option( 'gva_disable_event', 'yes' );