<?php 
/**
 * Plugin Name: Gavias Oxpitan Themer
 * Description: Open Setting, Post Type, Shortcode ... for theme 
 * Version: 1.4.0
 * Author: Gavias Team
 */

define( 'GAVIAS_ELEMENT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'GAVIAS_ELEMENT_PLUGIN_DIR', plugin_dir_path( __FILE__ )  );

class Gavias_Oxpitan_Themer{

	public function __construct(){
		$this->load_language_file();
		$this->include_files();
		$this->include_post_types();
      add_action('wp_head', array($this, 'gaviasthemer_ajax_url'));
      add_action('wp_enqueue_scripts', array($this, 'register_scripts'));

      $this->gavias_plugin_update();
	}
   
   public function gaviasthemer_ajax_url(){
     echo '<script> var ajaxurl = "' . admin_url('admin-ajax.php') . '";</script>';
   }
   public function load_language_file(){
      load_plugin_textdomain('gaviasthemer', false, basename( dirname( __FILE__ ) ) . '/languages' );
   }

	public function include_files(){
      require_once('redux/admin-init.php');
      require_once('includes/functions.php');
		require_once('includes/hook.php');
      require_once('elementor/init.php');   
	}

	public function include_post_types(){
      require_once('posttypes/footer.php');
      
		require_once('posttypes/gallery.php');
      if(get_option( 'gva_disable_event', 'yes' ) == 'yes'){
		    require_once('posttypes/event.php');
      }

		require_once('posttypes/portfolio.php');
      require_once('posttypes/team.php');
       if( in_array( 'give/give.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
         require_once('includes/give.php');
      	require_once('widgets/give-recent.php');
      	require_once('widgets/give-categories.php');
      }
	}

   public function register_scripts(){
      $js_dir = plugin_dir_url( __FILE__ ).'assets/js';
      wp_register_script('gavias-themer', $js_dir.'/main.js', array('jquery'), null, true);
      wp_enqueue_script('gavias-themer');
   }

   public function gavias_plugin_update() {
      require 'plugin-update/plugin-update-checker.php';
      Puc_v4_Factory::buildUpdateChecker(
         'http://gaviasthemes.com/plugins/dummy_data/oxpitan-themer-update-plugin.json',
         __FILE__,
         'gavias-oxpitan-themer'
      );
   }

}

new Gavias_Oxpitan_Themer();
