<?php
   if (!defined('ABSPATH')) {
      exit; // Exit if accessed directly.
   }

   use Elementor\Group_Control_Image_Size;

   $this->add_render_attribute('wrapper', 'class', ['gva-brand-carousel' ]);
   $this->add_render_attribute('carousel', 'class', ['init-carousel-owl owl-carousel']);
?>

   <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
      <div <?php echo $this->get_render_attribute_string('carousel') ?> <?php echo $this->get_carousel_settings() ?>>
         <?php
         $i = 0;
         foreach ($settings['brands'] as $brand): $i++; $_tag = 'span'; ?>
            <?php
               if ( ! empty( $brand['link']['url'] ) ) {
                  $this->add_render_attribute( "link_{$i}", 'href', $brand['link']['url'] );
                  $_tag = 'a';

                  if ( $brand['link']['is_external'] ) {
                     $this->add_render_attribute( "link_{$i}", 'target', '_blank' );
                  }

                  if ( $brand['link']['nofollow'] ) {
                     $this->add_render_attribute( "link_{$i}", 'rel', 'nofollow' );
                  }
               }
            ?>
            <div class="item brand-item">

               <div class="brand-item-content">
                  <<?php echo $_tag ?> <?php echo $this->get_render_attribute_string( "link_{$i}" ) ?> >
                     <?php
                        $image_html = Group_Control_Image_Size::get_attachment_image_html($brand, 'image');
                        echo $image_html;
                     ?>
                   </<?php echo $_tag ?>>
               </div>
              
            </div>
         <?php endforeach; ?>
      </div>
   </div>
