<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

class GVAElement_Services_Box extends  GVAElement_Base {

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'gva-services-box';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('GVA Services Box', 'gaviasthemer');
    }

     public function get_keywords() {
        return [ 'services', 'icon', 'carousel', 'grid' ];
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-person';
    }

    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'gavias.elements',
      ];
    }

    public function get_style_depends() {
        return [
            'owl-carousel-css',
        ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_data',
            [
                'label' => __('Data', 'gaviasthemer'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
           'box_title',
            [
                'label'   => __('Title', 'gaviasthemer'),
                'default' => 'Religion',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
           'use_icon_image',
            [
                'label'         => __( 'Use Icon Image', 'gaviasthemer' ),
                'type'          => Controls_Manager::SWITCHER,
                'placeholder'   => __( 'Use Icon Image or Icon Font', 'gaviasthemer' ),
                'default'       => 'yes'
            ]
        );
        $repeater->add_control(
           'icon',
            [
                'label'         => __( 'Icon Class', 'gaviasthemer' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => 'gv-icon-75',
                'placeholder'   => __( 'gv-icon-75', 'gaviasthemer' ),
                'description'   => 'Use class icon font <a target="_blank" href="http://fontawesome.io/icons/">Icon Awesome</a> or <a target="_blank" href="http://gaviasthemes.com/icons/ionicon/">Custom icon</a>',
                'condition'     => [
                    'use_icon_image!' => 'yes'
                ],
            ]
        );
        $repeater->add_control(
           'icon_image',
            [
                'label'         => __( 'Icon Image', 'gaviasthemer' ),
                'type'          => Controls_Manager::MEDIA,
                'default'       => [
                    'url' => GAVIAS_ELEMENT_PLUGIN_URL . 'elementor/assets/images/icon-placeholder-white.png',
                ],
                'condition'     => [
                    'use_icon_image' => 'yes',
                ]
            ]
        );
        $repeater->add_control(
           'link',
            [  
                'label'         => __( 'Link', 'gaviasthemer' ),
                'type'          => Controls_Manager::URL,
                'placeholder'   => __( 'https://your-link.com', 'gaviasthemer' ),
                'separator'     => 'before',
            ]
        );
        $repeater->add_control(
           'box_color',
            [
                'label'     => __('Box Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#E36955',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.service-item > .content-inner' => 'background: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}}.service-item > .content-inner::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'data_services',
            [
                'label'       => __('Box Item', 'gaviasthemer'),
                'type'        => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ box_title }}}',
                'default'     => array(
                    array(
                        'box_title'                 => esc_html__( 'Religion', 'gaviasthemer' ),
                        'use_icon_image'        => 'yes',
                        'icon'                  => '',
                        'box_color'             => '#50BAC3',
                    ),
                    array(
                        'box_title'             => esc_html__( 'Medical', 'gaviasthemer' ),
                        'use_icon_image'        => 'yes',
                        'icon'                  => '',
                        'box_color'             => '#E36955',

                    ),
                    array(
                        'box_title'             => esc_html__( 'Family', 'gaviasthemer' ),
                        'use_icon_image'        => 'yes',
                        'icon'                  => '',
                        'box_color'             => '#F1AE44'

                    ),
                    array(
                        'box_title'             => esc_html__( 'Education', 'gaviasthemer' ),
                        'use_icon_image'        => 'yes',
                        'icon'                  => '',
                        'box_color'             => '#863BAE'
                    ),
                    array(
                        'box_title'             => esc_html__( 'Animals', 'gaviasthemer' ),
                        'use_icon_image'        => 'yes',
                        'icon'                  => '',
                        'box_color'             => '#424242'
                    ),
                ),
            ]
        );

        $this->add_control(
            'header_tag',
            [
                'label' => __( 'Title HTML Tag', 'gaviasthemer' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h3',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_box_layout',
            [
                'label' => __('Layout', 'gaviasthemer'),
                'type'  => Controls_Manager::SECTION,
            ]
        );
         $this->add_control(
            'layout',
            [
                'label'   => __( 'Layout Display', 'gaviasthemer' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'carousel',
                'options' => [
                    //'grid'      => __( 'Grid', 'gaviasthemer' ),
                    'carousel'  => __( 'Carousel', 'gaviasthemer' ),
                ]
            ]
        );

        $this->end_controls_section();


        $this->add_control_carousel(false, array('layout' => 'carousel'));

        $this->add_control_grid(array('layout' => 'grid'));


        $this->start_controls_section(
            'section_team_style',
            [
                'label' => __('Description', 'gaviasthemer'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label'     => __('Text Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-team-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'selector' => '{{WRAPPER}} .elementor-team-content',
            ]
        );

        $this->end_controls_section();

        // Name Styling
        $this->start_controls_section(
            'section_style_team_name',
            [
                'label' => __('Name', 'gaviasthemer'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_text_color',
            [
                'label'     => __('Text Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-team-name, {{WRAPPER}} .elementor-team-name a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .elementor-team-name',
            ]
        );

        $this->end_controls_section();

        // Job Styling
        $this->start_controls_section(
            'section_style_team_job',
            [
                'label' => __('Job', 'gaviasthemer'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'job_text_color',
            [
                'label'     => __('Text Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-team-job' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'job_typography',
                'selector' => '{{WRAPPER}} .elementor-team-job',
            ]
        );

        $this->end_controls_section();

        // Information Styling
        $this->start_controls_section(
            'section_style_team_information',
            [
                'label' => __('Information', 'gaviasthemer'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'information_text_color',
            [
                'label'     => __('Text Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-team-infomation' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'information_typography',
                'selector' => '{{WRAPPER}} .elementor-team-infomation',
            ]
        );

        $this->end_controls_section();

        // Information.
        $this->start_controls_section(
            'section_style_team_social',
            [
                'label' => __('Social', 'gaviasthemer'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'social_color',
            [
                'label'     => __('Social Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-team-socials li.social .fa' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_hover_color',
            [
                'label'     => __('Social Hover Color', 'gaviasthemer'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-team-socials li.social .fa:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        printf( '<div class="gva-element-%s gva-element">', $this->get_name() );
        if( !empty($settings['layout']) ){
            include $this->get_template('services-box/' . $settings['layout'] . '.php');
        }
        print '</div>'; 
    }

}
